close all

L = 80;
lognc = 6;
sLL = 28;
seed = 0;
Lvalues = [50,80];
measvalues = {'r','dpq','K','Y'};
colours = {'r',[0 0.5 0],'k','b'};
meas = 'r';
formatSpec = '%f';

Knorm=zeros(1,2);

for k=1:2
L = Lvalues(k);    
for j=1:4
meas = measvalues{j};
FILENAME = sprintf('%d,%sAutoCorr1,%d,%d,%d.txt',seed,meas,L,lognc,sLL);

fileID = fopen(FILENAME,'r');

A = fscanf(fileID,formatSpec);

ft = A(1:46,1);

if meas=='K'
    Knorm(1,k) = ft(46,1);
end

btimes = zeros(1,8);
for i=1:8
    btimes(1,i)=i*100;
end

times = zeros(1,7);
for i=1:7
    times(1,i)=890+i*10;
end

ftimes = zeros(1,31);
for i=1:31
    ftimes(1,i)=969+i;
end

t970=A(47:77,1)/ft(46,1);
t980=A(78:108,1)/ft(46,1);
t990=A(109:139,1)/ft(46,1);

ft=(ft/ft(46,1));

reltimes = 10000-([btimes,times,ftimes]*10);
reltimes2 = 10000-(ftimes*10);

if meas=='r'
    meas='$r$';
end

if meas=='dpq'
    meas='$|\delta\rho_1|^2$';
end

if meas=='Y'
    meas='$\Upsilon$';
end

if meas=='K'
    meas='$K^{\beta}$';
end

figure((k-1)*(size(measvalues,2)+1)+1)
hold on, plot(reltimes,ft,'color',colours{j},'linewidth',4,'DisplayName',meas);
set(gca,'xscale','log')
xlabel('$t_{obs}- t$','interpreter','latex');

yname = '$C_F(t,t_{obs})$';
ylabel(yname,'interpreter','latex');
set(gca, 'FontSize', 24);
set(gca, 'linewidth', 2);

xlim([10,1000]);
ylim([-0.1,1.14]);

yname = sprintf('R(t,t_{obs}) of %s',meas);

if strcmp(meas,'$r$')==1
    meas='r';
end

if strcmp(meas,'$|\delta\rho_1|^2$')==1
    meas='dpq';
end

if strcmp(meas,'$\Upsilon$')==1
    meas='Y';
end

if strcmp(meas,'$K^{\beta}$')==1
    meas='K';
end

figure,plot(reltimes(1,16:46),ft(16:46,1),'x');
hold on,plot(reltimes2(1,:),t970(:,1),'x');
hold on,plot(reltimes2(1,:),t980(:,1),'x');
hold on,plot(reltimes2(1,:),t990(:,1),'x');
xlabel('$t_{obs}- t$','interpreter','latex');
ylabel(yname);

set(gca, 'FontSize', 24);
set(gcf,'units','points','position',[10,10,400,300]);
set(gca,'box','off');
set(gca,'linewidth',2);

plotname = sprintf('%d,%sAutoCorr1,%d,%d,%d.png',seed,meas,L,lognc,sLL);
saveas(gcf,plotname)
end
end

for k=1:2
    L = Lvalues(k); 
    figure((k-1)*(size(measvalues,2)+1)+1), hold on, text(380,0.83,'$r$','FontSize',22,'interpreter','latex');
    hold on, plot([220,331],[0.83,0.83],'color',colours{1},'linewidth',4);
    figure((k-1)*(size(measvalues,2)+1)+1), hold on, text(380,0.72,'$|\delta\rho_1|^2$','FontSize',22,'interpreter','latex');
    hold on, plot([220,331],[0.72,0.72],'color',colours{2},'linewidth',4);
    figure((k-1)*(size(measvalues,2)+1)+1), hold on, text(21,0.1,'$K^{\beta}$','FontSize',22,'interpreter','latex');
    hold on, plot([12,18],[0.1,0.1],'color',colours{3},'linewidth',4);
    figure((k-1)*(size(measvalues,2)+1)+1), hold on, text(21,-0.01,'$\Upsilon$','FontSize',22,'interpreter','latex');
    hold on, plot([12,18],[-0.01,-0.01],'color',colours{4},'linewidth',4);
    figlabel = sprintf('L=%d',L);
    figure((k-1)*(size(measvalues,2)+1)+1), hold on, text(82,1.04,figlabel,'FontSize',34,'interpreter','latex');
    
    logplotname = sprintf('%dlogAutoCorr1,%d,%d,%d.png',seed,L,lognc,sLL);
    saveas(gcf,logplotname)

end